local plugin_db_path = current_mod_path..'/Database/'

--------------------------------------------------------------------------
-- Cars
--------------------------------------------------------------------------

local function chassis_file(f)
    if dofile(plugin_db_path..f) then
		error("can't load file "..f)
		return
	end
end

local function vehicle_file(f)
	if dofile(plugin_db_path..f) then
		error("can't load file "..f)
		return
	end
	if(GT) then
		GT.shape_table_data = 
		{
			{
				file  	    = GT.visual.shape;
				username    = GT.Name;
				desrt       = GT.visual.shape_dstr;
			    classname 	= "lLandVehicle";
				
				positioning = GT.positioning or "BYNORMAL";
				--"BYNORMAL",	-- use normal from surface to form UP  ( y) axis 
				--"ONLYHEIGTH",	-- given position normalized ,  p.y  set to surface height value
				--"BY_XZ",	-- project x , z axis from given position projected to surface , 
				--"NO",			-- No transforms
				--"ADD_HEIGTH"	-- No transforms, only hight of surface are added to hight of object
				
				life		= GT.life or 6;
			},
			{
				name  = GT.visual.shape_dstr;
				file  = GT.visual.shape_dstr;
			},
		}
		add_surface_unit(GT)
		GT = nil;
	else
		error("GT empty in file "..f)
	end;
end

--- BEGIN Vehicles
GT = nil;




-- Somali Sedan
chassis_file("chassis/bhd_sedan_chassis.lua")
vehicle_file("vehicles/bhd_sedan.lua")

-- Somali Pickup
chassis_file("chassis/bhd_somali_pickup_chassis.lua")
vehicle_file("vehicles/bhd_somali_pickup_pkm.lua")

-- Somali Truck
chassis_file("chassis/bhd_somali_truck_chassis.lua")
vehicle_file("vehicles/bhd_somali_truck.lua")




